from parallels.target_panel_plesk.import_api.import_api_base import \
		PleskBaseImportAPI
from parallels.common.import_api.utils import plesk_unix_change_sysuser_login

class PleskUnixImportAPI(PleskBaseImportAPI):
	def change_sysuser_login(self, subscription_name, sysuser_login):
		with self.conn.main_node_runner() as runner:
			plesk_unix_change_sysuser_login(runner, subscription_name, sysuser_login)

	def repair_webspace_security(self, domain_name):
		raise NotImplementedError(
			u"Repair webspace security is a Windows-specific function and can not be applied to Plesk for Unix"
		)

	def update_webspace_subdomains_security_metadata_location(self, domain_name):
		raise NotImplementedError(
			u"Update webspace subdomains security metadata location is a Windows-specific function and can not be applied to Plesk for Unix"
		)

	def get_dedicated_app_pool_user(self, subscription_name):
		raise NotImplementedError(
			u"Get dedicated application pool user is a Windows-specific function and can not be applied to Plesk for Unix"
		)

	def refresh_node_components(self, node):
		raise NotImplementedError(
			u"Refresh node components is a Windows-specific function and can not be applied to Plesk for Unix"
		)

