import posixpath

from parallels.utils import obj
from parallels.common.utils import plesk_utils
from parallels.plesks_migrator.actions.content.web.copy_unix_content \
		import CopyUnixWebContentBase

class ConfixxCopyUnixWebContent(CopyUnixWebContentBase):
	def _list_files_to_copy(self, global_context, subscription):
		"""Make a list of source server directories to be transferred.

		Confixx content directories:
		Domain root directory of user webN:
			'/srv/www/htdocs/webN/html'
		Web statistics (webalizer):
			'/srv/www/htdocs/confixx/html/webalizer/webN' 
		Web statistics (awstats):
			'/srv/www/htdocs/confixx/awstats/webN' 
		Apache log files:
			'/srv/www/htdocs/webN/log'

		Return:
			A list of (source directory -> destination directory) mappings
		"""
		vhosts_dir = global_context.confixx_configuration.get_vhosts_dir()
		source_vhost_name = subscription.raw_backup.owner_login
		vhost_name = subscription.name.encode('idna')
		tocopy = [
			obj(source_subdir=posixpath.join(vhosts_dir, source_vhost_name, 'html'),
				target_subdir=posixpath.join(vhost_name, 'httpdocs'), exclude=[],
				skip_if_source_not_exists=False),
			obj(source_subdir=posixpath.join(vhosts_dir, source_vhost_name,"log"),
				target_subdir=u"system/%s/logs" % vhost_name, exclude=[],
				skip_if_source_not_exists=True),
		]

		for site in subscription.raw_backup.iter_sites():
			site_vhost_name = plesk_utils.convert_wildcard_to_path(
					site.name.encode('idna')
			)
			
			target_logs_subdir = (
					u"system/{site_vhost}/logs".format(site_vhost=site_vhost_name))
			
			tocopy.extend([
				obj(source_subdir=posixpath.join(vhosts_dir, site_vhost_name, 'log'),
					target_subdir=target_logs_subdir, exclude=[],
					skip_if_source_not_exists=True),    # site logs
			])

		return tocopy
