from parallels.common.actions.base.subscription_action import SubscriptionAction

class CheckTargetWebHosting(SubscriptionAction):
	"""Check that each subscription with virtual hosting has target web IP"""

	def get_description(self):
		return "Check that each subscription with virtual hosting has web IP"

	def get_failure_message(self, global_context, subscription):
		return "Failed to check if subscription '%s' has web IP" % (subscription.name)

	def filter_subscription(self, global_context, subscription):
		return subscription.raw_backup.hosting_type == 'phosting'

	def run(self, global_context, subscription):
		if subscription.web_target_server is None:
			raise Exception(
				u"Unable to copy web content: web hosting of the corresponding PPA webspace is not configured."
				u"Make sure that web hosting of the corresponding PPA webspace is configured."
			)
