/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.ExportConfig;
import com.sun.electric.tool.generator.layout.fill.FillGeneratorTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FillGenConfig
implements Serializable {
    public TechType techType = null;
    public FillGeneratorTool.FillTypeEnum fillType = FillGeneratorTool.FillTypeEnum.INVALID;
    public String fillLibName;
    List<ReserveConfig> reserves = new ArrayList<ReserveConfig>();
    public boolean evenLayersHorizontal;
    public double width;
    public double height;
    public double targetW;
    public double targetH;
    public double minTileSizeX;
    public double minTileSizeY;
    public ExportConfig perim;
    public int firstLayer;
    public int lastLayer;
    public int[] cellTiles;
    public boolean hierarchy;
    public double minOverlap;
    public double drcSpacingRule;
    public boolean binary;
    public boolean useMaster;
    public boolean onlyAround;
    public double gap;
    public FillGenType fillCellType = FillGenType.INTERNAL;
    public int level;
    public Job job;

    public FillGenConfig(FillGeneratorTool.FillTypeEnum type, TechType tech, String lib, ExportConfig perim, int first, int last, double w, double h, boolean even, int[] cellTiles, boolean hierarchy, double minO, double drcSpacingRule, boolean binary, boolean useMaster, boolean onlyAround, double gap, FillGenType genType, int level) {
        this.fillType = type;
        this.cellTiles = cellTiles;
        this.hierarchy = hierarchy;
        this.minOverlap = minO;
        this.drcSpacingRule = drcSpacingRule;
        this.binary = binary;
        this.width = w;
        this.height = h;
        this.evenLayersHorizontal = even;
        this.useMaster = useMaster;
        this.techType = tech;
        Tech.setTechnology(tech);
        this.fillLibName = lib;
        this.perim = perim;
        this.firstLayer = first;
        this.lastLayer = last;
        this.onlyAround = onlyAround;
        this.gap = gap;
        this.fillCellType = genType;
        this.level = level;
    }

    public void setTargetValues(double targetW, double targetH, double sx, double sy) {
        this.targetW = targetW;
        this.targetH = targetH;
        this.minTileSizeX = sx;
        this.minTileSizeY = sy;
    }

    public ReserveConfig reserveSpaceOnLayer(Technology tech, int layer, double vddReserved, FillGeneratorTool.Units vddUnits, double gndReserved, FillGeneratorTool.Units gndUnits) {
        int numMetals = tech.getNumMetals();
        LayoutLib.error(layer < 1 || layer > numMetals, "Bad layer. Layers must be between 2 and " + numMetals + " inclusive: " + layer);
        ReserveConfig config = new ReserveConfig(layer, vddReserved, gndReserved, vddUnits, gndUnits);
        this.reserves.add(config);
        return config;
    }

    public static class ReserveConfig
    implements Serializable {
        int layer;
        double vddReserved;
        double gndReserved;
        double vddWidth;
        double gndWidth;
        FillGeneratorTool.Units vddUnits;
        FillGeneratorTool.Units gndUnits;
        FillGeneratorTool.Units vddWUnits;
        FillGeneratorTool.Units gndWUnits;

        ReserveConfig(int layer, double vddReserved, double gndReserved, FillGeneratorTool.Units vddUnits, FillGeneratorTool.Units gndUnits) {
            this.layer = layer;
            this.vddReserved = vddReserved;
            this.gndReserved = gndReserved;
            this.vddUnits = vddUnits;
            this.gndUnits = gndUnits;
            this.vddWUnits = FillGeneratorTool.Units.NONE;
            this.gndWUnits = FillGeneratorTool.Units.NONE;
        }

        public void reserveWidthOnLayer(double vddW, FillGeneratorTool.Units vddUnits, double gndW, FillGeneratorTool.Units gndUnits) {
            this.vddWidth = vddW;
            this.gndWidth = gndW;
            this.vddWUnits = vddUnits;
            this.gndWUnits = gndUnits;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FillGenType {
        INTERNAL(0),
        ONLYSKILL(1),
        SEAGATES(2);

        private final int mode;

        private FillGenType(int m) {
            this.mode = m;
        }

        public int getMode() {
            return this.mode;
        }

        public static FillGenType find(int mode) {
            for (FillGenType m : FillGenType.values()) {
                if (m.mode != mode) continue;
                return m;
            }
            return INTERNAL;
        }
    }
}

