/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Tool;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;

public class IOTool
extends Tool {
    private static IOTool tool = new IOTool();
    public static final Variable.Key IO_TRUE_LIBRARY = Variable.newKey("IO_true_library");
    private static boolean skillChecked = false;
    private static Class<?> skillClass = null;
    private static Method skillOutputMethod;
    private static boolean daisChecked;
    private static Class<?> daisClass;
    private static Method daisInputMethod;
    private static Pref cacheBackupRedundancy;
    private Setting cacheUseCopyrightMessage;
    private Setting cacheCopyrightMessage;
    private static Pref cachePlotArea;
    private static Pref cachePlotDate;
    private static Pref cachePrinterName;
    private Setting cacheCIFMimicsDisplay;
    private Setting cacheCIFMergesBoxes;
    private Setting cacheCIFInstantiatesTopLevel;
    private static Pref cacheCIFInSquaresWires;
    private static Pref cacheDEFLogicalPlacement;
    private static Pref cacheDEFPhysicalPlacement;
    private Setting cacheGDSMergesBoxes;
    private Setting cacheGDSWritesExportPins;
    private Setting cacheGDSOutputUpperCase;
    private Setting cacheGDSDefaultTextLayer;
    private Setting cacheGDSOutputConvertsBracketsInExports;
    private Setting cacheGDSCellNameLenMax;
    private static Pref cacheGDSInMergesBoxes;
    private static Pref cacheGDSInIncludesText;
    private static Pref cacheGDSInExpandsCells;
    private static Pref cacheGDSInInstantiatesArrays;
    private static Pref cacheGDSInIgnoresUnknownLayers;
    private static Pref cacheGDSConvertNCCExportsConnectedByParentPins;
    private static Pref cacheGDSInSimplifyCells;
    private static Pref cacheGDSColapseVddGndPinNames;
    private static Pref cachePrintEncapsulated;
    private static Pref cachePrintResolution;
    private static Pref cachePrintForPlotter;
    private static Pref cachePrintWidth;
    private static Pref cachePrintHeight;
    private static Pref cachePrintMargin;
    private static Pref cachePrintRotation;
    private static Pref cachePrintColorMethod;
    public static final Variable.Key POSTSCRIPT_EPS_SCALE;
    public static final Variable.Key POSTSCRIPT_FILENAME;
    public static final Variable.Key POSTSCRIPT_FILEDATE;
    private static Pref cachePrintPSLineWidth;
    private static Pref cacheEDIFUseSchematicView;
    private static Pref cacheEDIFCadenceCompatibility;
    private static Pref cacheEDIFInputScale;
    private static Pref cacheEDIFConfigurationFile;
    private Setting cacheDXFScale;
    private static Pref cacheDXFInputFlattensHierarchy;
    private static Pref cacheDXFInputReadsAllLayers;
    private static Pref cacheSueUses4PortTransistors;
    private static Pref cacheSueConvertsExpressions;
    private static Pref cacheSkillExcludesSubcells;
    private static Pref cacheSkillFlattensHierarchy;
    private static Pref cacheSkillGDSNameLimit;
    private static Pref cacheDaisDisplayOnly;
    private static Pref cacheDaisReadCellInstances;
    private static Pref cacheDaisReadDetailWires;
    private static Pref cacheDaisReadGlobalWires;
    private static Pref cacheDaisReadPowerAndGround;
    private static Pref cacheDaisReadConnectivity;

    protected IOTool() {
        super("io");
    }

    public static IOTool getIOTool() {
        return tool;
    }

    public static boolean hasSkill() {
        if (!skillChecked) {
            skillChecked = true;
            try {
                skillClass = Class.forName("com.sun.electric.plugins.skill.Skill");
            }
            catch (ClassNotFoundException e) {
                skillClass = null;
                return false;
            }
            try {
                skillOutputMethod = skillClass.getMethod("writeSkillFile", Cell.class, String.class, Boolean.class);
            }
            catch (NoSuchMethodException e) {
                skillClass = null;
                return false;
            }
        }
        return skillClass != null;
    }

    public static void writeSkill(Cell cell, String fileName, boolean exportsOnly) {
        if (!IOTool.hasSkill()) {
            return;
        }
        try {
            skillOutputMethod.invoke(skillClass, cell, fileName, new Boolean(exportsOnly));
        }
        catch (Exception e) {
            System.out.println("Unable to run the Skill output module");
            e.printStackTrace(System.out);
        }
    }

    public static boolean hasDais() {
        if (!daisChecked) {
            daisChecked = true;
            try {
                daisClass = Class.forName("com.sun.electric.plugins.dais.Dais");
            }
            catch (ClassNotFoundException e) {
                daisClass = null;
                return false;
            }
            try {
                daisInputMethod = daisClass.getMethod("readDaisFile", URL.class, Library.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                daisClass = null;
                return false;
            }
        }
        return daisClass != null;
    }

    public static void readDais(URL url, Library lib, boolean newLib) {
        if (!IOTool.hasDais()) {
            return;
        }
        try {
            daisInputMethod.invoke(daisClass, url, lib, newLib);
        }
        catch (Exception e) {
            System.out.println("Unable to run the Dais input module (" + e.getClass() + ")");
            e.printStackTrace(System.out);
        }
    }

    protected void initProjectSettings() {
        this.initGeneralOutputProjectSettings();
        this.initCIFProjectSettings();
        this.initGDSProjectSettings();
        this.initDXFProjectSettings();
    }

    public static int getBackupRedundancy() {
        return cacheBackupRedundancy.getInt();
    }

    public static void setBackupRedundancy(int r) {
        cacheBackupRedundancy.setInt(r);
    }

    public static boolean isUseCopyrightMessage() {
        return IOTool.tool.cacheUseCopyrightMessage.getBoolean();
    }

    public static Setting getUseCopyrightMessageSetting() {
        return IOTool.tool.cacheUseCopyrightMessage;
    }

    public static String getCopyrightMessage() {
        return IOTool.tool.cacheCopyrightMessage.getString();
    }

    public static Setting getCopyrightMessageSetting() {
        return IOTool.tool.cacheCopyrightMessage;
    }

    private void initGeneralOutputProjectSettings() {
        this.makeBooleanSetting("UseCopyrightMessage", "Netlists tab", "Use copyright message", false);
        this.makeStringSetting("CopyrightMessage", "Netlists tab", "Copyright message", "");
    }

    public static int getPlotArea() {
        return cachePlotArea.getInt();
    }

    public static void setPlotArea(int pa) {
        cachePlotArea.setInt(pa);
    }

    public static boolean isPlotDate() {
        return cachePlotDate.getBoolean();
    }

    public static void setPlotDate(boolean pd) {
        cachePlotDate.setBoolean(pd);
    }

    private static Pref getCachePrinterName() {
        if (cachePrinterName == null) {
            cachePrinterName = Pref.makeStringPref("PrinterName", IOTool.tool.prefs, "");
        }
        return cachePrinterName;
    }

    public static String getPrinterName() {
        return IOTool.getCachePrinterName().getString();
    }

    public static void setPrinterName(String pName) {
        IOTool.getCachePrinterName().setString(pName);
    }

    public static boolean isCIFOutMimicsDisplay() {
        return IOTool.tool.cacheCIFMimicsDisplay.getBoolean();
    }

    public static Setting getCIFOutMimicsDisplaySetting() {
        return IOTool.tool.cacheCIFMimicsDisplay;
    }

    public static boolean isCIFOutMergesBoxes() {
        return IOTool.tool.cacheCIFMergesBoxes.getBoolean();
    }

    public static Setting getCIFOutMergesBoxesSetting() {
        return IOTool.tool.cacheCIFMergesBoxes;
    }

    public static boolean isCIFOutInstantiatesTopLevel() {
        return IOTool.tool.cacheCIFInstantiatesTopLevel.getBoolean();
    }

    public static Setting getCIFOutInstantiatesTopLevelSetting() {
        return IOTool.tool.cacheCIFInstantiatesTopLevel;
    }

    private void initCIFProjectSettings() {
        this.makeBooleanSetting("CIFMimicsDisplay", "CIF tab", "CIF output mimics display", false);
        this.makeBooleanSetting("CIFMergesBoxes", "CIF tab", "CIF output merges boxes", false);
        this.makeBooleanSetting("CIFInstantiatesTopLevel", "CIF tab", "CIF output instantiates top level", true);
    }

    public static boolean isCIFInSquaresWires() {
        return cacheCIFInSquaresWires.getBoolean();
    }

    public static void setCIFInSquaresWires(boolean s) {
        cacheCIFInSquaresWires.setBoolean(s);
    }

    public static boolean isDEFLogicalPlacement() {
        return cacheDEFLogicalPlacement.getBoolean();
    }

    public static void setDEFLogicalPlacement(boolean on) {
        cacheDEFLogicalPlacement.setBoolean(on);
    }

    public static boolean isDEFPhysicalPlacement() {
        return cacheDEFPhysicalPlacement.getBoolean();
    }

    public static void setDEFPhysicalPlacement(boolean on) {
        cacheDEFPhysicalPlacement.setBoolean(on);
    }

    public static boolean isGDSOutMergesBoxes() {
        return IOTool.tool.cacheGDSMergesBoxes.getBoolean();
    }

    public static Setting getGDSOutMergesBoxesSetting() {
        return IOTool.tool.cacheGDSMergesBoxes;
    }

    public static boolean isGDSOutWritesExportPins() {
        return IOTool.tool.cacheGDSWritesExportPins.getBoolean();
    }

    public static Setting getGDSOutWritesExportPinsSetting() {
        return IOTool.tool.cacheGDSWritesExportPins;
    }

    public static boolean isGDSOutUpperCase() {
        return IOTool.tool.cacheGDSOutputUpperCase.getBoolean();
    }

    public static Setting getGDSOutUpperCaseSetting() {
        return IOTool.tool.cacheGDSOutputUpperCase;
    }

    public static int getGDSOutDefaultTextLayer() {
        return IOTool.tool.cacheGDSDefaultTextLayer.getInt();
    }

    public static Setting getGDSOutDefaultTextLayerSetting() {
        return IOTool.tool.cacheGDSDefaultTextLayer;
    }

    public static boolean getGDSOutputConvertsBracketsInExports() {
        return IOTool.tool.cacheGDSOutputConvertsBracketsInExports.getBoolean();
    }

    public static Setting getGDSOutputConvertsBracketsInExportsSetting() {
        return IOTool.tool.cacheGDSOutputConvertsBracketsInExports;
    }

    public static int getGDSCellNameLenMax() {
        return IOTool.tool.cacheGDSCellNameLenMax.getInt();
    }

    public static Setting getGDSCellNameLenMaxSetting() {
        return IOTool.tool.cacheGDSCellNameLenMax;
    }

    private void initGDSProjectSettings() {
        this.makeBooleanSetting("GDSMergesBoxes", "GDS tab", "GDS output merges boxes", false);
        this.makeBooleanSetting("GDSWritesExportPins", "GDS tab", "GDS output writes export pins", false);
        this.makeBooleanSetting("GDSOutputUpperCase", "GDS tab", "GDS output all upper-case", false);
        this.makeIntSetting("GDSDefaultTextLayer", "GDS tab", "GDS output default text layer", 230);
        this.makeBooleanSetting("GDSOutputConvertsBracketsInExports", "GDS tab", "GDS output converts brackets in exports", true);
        this.makeIntSetting("GDSCellNameLenMax", "GDS tab", "GDS name length limit", 32);
    }

    public static boolean isGDSInMergesBoxes() {
        return cacheGDSInMergesBoxes.getBoolean();
    }

    public static void setGDSInMergesBoxes(boolean on) {
        cacheGDSInMergesBoxes.setBoolean(on);
    }

    public static boolean isGDSInIncludesText() {
        return cacheGDSInIncludesText.getBoolean();
    }

    public static void setGDSInIncludesText(boolean on) {
        cacheGDSInIncludesText.setBoolean(on);
    }

    public static boolean isGDSInExpandsCells() {
        return cacheGDSInExpandsCells.getBoolean();
    }

    public static void setGDSInExpandsCells(boolean on) {
        cacheGDSInExpandsCells.setBoolean(on);
    }

    public static boolean isGDSInInstantiatesArrays() {
        return cacheGDSInInstantiatesArrays.getBoolean();
    }

    public static void setGDSInInstantiatesArrays(boolean on) {
        cacheGDSInInstantiatesArrays.setBoolean(on);
    }

    public static boolean isGDSInIgnoresUnknownLayers() {
        return cacheGDSInIgnoresUnknownLayers.getBoolean();
    }

    public static void setGDSInIgnoresUnknownLayers(boolean on) {
        cacheGDSInIgnoresUnknownLayers.setBoolean(on);
    }

    public static boolean getGDSConvertNCCExportsConnectedByParentPins() {
        return cacheGDSConvertNCCExportsConnectedByParentPins.getBoolean();
    }

    public static void setGDSConvertNCCExportsConnectedByParentPins(boolean b) {
        cacheGDSConvertNCCExportsConnectedByParentPins.setBoolean(b);
    }

    public static boolean isGDSInSimplifyCells() {
        return cacheGDSInSimplifyCells.getBoolean();
    }

    public static void setGDSInSimplifyCells(boolean on) {
        cacheGDSInSimplifyCells.setBoolean(on);
    }

    public static boolean isGDSColapseVddGndPinNames() {
        return cacheGDSColapseVddGndPinNames.getBoolean();
    }

    public static void setGDSColapseVddGndPinNames(boolean on) {
        cacheGDSColapseVddGndPinNames.setBoolean(on);
    }

    public static boolean isPrintEncapsulated() {
        return cachePrintEncapsulated.getBoolean();
    }

    public static void setPrintEncapsulated(boolean on) {
        cachePrintEncapsulated.setBoolean(on);
    }

    public static int getPrintResolution() {
        return cachePrintResolution.getInt();
    }

    public static void setPrintResolution(int r) {
        cachePrintResolution.setInt(r);
    }

    public static boolean isPrintForPlotter() {
        return cachePrintForPlotter.getBoolean();
    }

    public static void setPrintForPlotter(boolean on) {
        cachePrintForPlotter.setBoolean(on);
    }

    public static double getPrintWidth() {
        return cachePrintWidth.getDouble();
    }

    public static void setPrintWidth(double wid) {
        cachePrintWidth.setDouble(wid);
    }

    public static double getPrintHeight() {
        return cachePrintHeight.getDouble();
    }

    public static void setPrintHeight(double hei) {
        cachePrintHeight.setDouble(hei);
    }

    public static double getPrintMargin() {
        return cachePrintMargin.getDouble();
    }

    public static void setPrintMargin(double mar) {
        cachePrintMargin.setDouble(mar);
    }

    public static int getPrintRotation() {
        return cachePrintRotation.getInt();
    }

    public static void setPrintRotation(int rot) {
        cachePrintRotation.setInt(rot);
    }

    public static int getPrintColorMethod() {
        return cachePrintColorMethod.getInt();
    }

    public static void setPrintColorMethod(int cm) {
        cachePrintColorMethod.setInt(cm);
    }

    public static double getPrintEPSScale(Cell cell) {
        Variable var = cell.getVar(POSTSCRIPT_EPS_SCALE);
        if (var != null) {
            Object obj = var.getObject();
            String desc = obj.toString();
            double epsScale = TextUtils.atof(desc);
            return epsScale;
        }
        return 1.0;
    }

    public static void setPrintEPSScale(Cell cell, double scale) {
        tool.setVarInJob(cell, POSTSCRIPT_EPS_SCALE, new Double(scale));
    }

    public static String getPrintEPSSynchronizeFile(Cell cell) {
        Variable var = cell.getVar(POSTSCRIPT_FILENAME);
        if (var != null) {
            Object obj = var.getObject();
            String desc = obj.toString();
            return desc;
        }
        return "";
    }

    public static void setPrintEPSSynchronizeFile(Cell cell, String syncFile) {
        tool.setVarInJob(cell, POSTSCRIPT_FILENAME, syncFile);
    }

    public static Date getPrintEPSSavedDate(Cell cell) {
        Variable varDate = cell.getVar(POSTSCRIPT_FILEDATE, Integer[].class);
        if (varDate == null) {
            return null;
        }
        Integer[] lastSavedDateAsInts = (Integer[])varDate.getObject();
        long lastSavedDateInSeconds = (long)lastSavedDateAsInts[0].intValue() << 32 | (long)(lastSavedDateAsInts[1] & 0xFFFFFFFF);
        Date lastSavedDate = new Date(lastSavedDateInSeconds);
        return lastSavedDate;
    }

    public static void setPrintEPSSavedDate(Cell cell, Date date) {
        long iVal = date.getTime();
        Integer[] dateArray = new Integer[]{new Integer((int)(iVal >> 32)), new Integer((int)(iVal & 0xFFFFFFFFFFFFFFFFL))};
        tool.setVarInJob(cell, POSTSCRIPT_FILEDATE, dateArray);
    }

    public static double getPrintPSLineWidth() {
        return cachePrintPSLineWidth.getDouble();
    }

    public static void setPrintPSLineWidth(double mar) {
        cachePrintPSLineWidth.setDouble(mar);
    }

    public static boolean isEDIFUseSchematicView() {
        return cacheEDIFUseSchematicView.getBoolean();
    }

    public static void setEDIFUseSchematicView(boolean f) {
        cacheEDIFUseSchematicView.setBoolean(f);
    }

    public static boolean isEDIFCadenceCompatibility() {
        return cacheEDIFCadenceCompatibility.getBoolean();
    }

    public static void setEDIFCadenceCompatibility(boolean c) {
        cacheEDIFCadenceCompatibility.setBoolean(c);
    }

    public static double getEDIFInputScale() {
        return cacheEDIFInputScale.getDouble();
    }

    public static void setEDIFInputScale(double f) {
        cacheEDIFInputScale.setDouble(f);
    }

    public static String getEDIFConfigurationFile() {
        return cacheEDIFConfigurationFile.getString();
    }

    public static void setEDIFConfigurationFile(String cFile) {
        cacheEDIFConfigurationFile.setString(cFile);
    }

    public static int getDXFScale() {
        return IOTool.tool.cacheDXFScale.getInt();
    }

    public static Setting getDXFScaleSetting() {
        return IOTool.tool.cacheDXFScale;
    }

    private void initDXFProjectSettings() {
        this.makeIntSetting("DXFScale", "DXF tab", "DXF scale factor", 2);
    }

    public static boolean isDXFInputFlattensHierarchy() {
        return cacheDXFInputFlattensHierarchy.getBoolean();
    }

    public static void setDXFInputFlattensHierarchy(boolean f) {
        cacheDXFInputFlattensHierarchy.setBoolean(f);
    }

    public static boolean isDXFInputReadsAllLayers() {
        return cacheDXFInputReadsAllLayers.getBoolean();
    }

    public static void setDXFInputReadsAllLayers(boolean a) {
        cacheDXFInputReadsAllLayers.setBoolean(a);
    }

    public static boolean isSueUses4PortTransistors() {
        return cacheSueUses4PortTransistors.getBoolean();
    }

    public static void setSueUses4PortTransistors(boolean on) {
        cacheSueUses4PortTransistors.setBoolean(on);
    }

    public static boolean isSueConvertsExpressions() {
        return cacheSueConvertsExpressions.getBoolean();
    }

    public static void setSueConvertsExpressions(boolean on) {
        cacheSueConvertsExpressions.setBoolean(on);
    }

    public static boolean isSkillExcludesSubcells() {
        return cacheSkillExcludesSubcells.getBoolean();
    }

    public static void setSkillExcludesSubcells(boolean on) {
        cacheSkillExcludesSubcells.setBoolean(on);
    }

    public static boolean isSkillFlattensHierarchy() {
        return cacheSkillFlattensHierarchy.getBoolean();
    }

    public static void setSkillFlattensHierarchy(boolean on) {
        cacheSkillFlattensHierarchy.setBoolean(on);
    }

    public static boolean isSkillGDSNameLimit() {
        return cacheSkillGDSNameLimit.getBoolean();
    }

    public static void setSkillGDSNameLimit(boolean on) {
        cacheSkillGDSNameLimit.setBoolean(on);
    }

    public static boolean isDaisDisplayOnly() {
        return cacheDaisDisplayOnly.getBoolean();
    }

    public static void setDaisDisplayOnly(boolean on) {
        cacheDaisDisplayOnly.setBoolean(on);
    }

    public static boolean isDaisReadCellInstances() {
        return cacheDaisReadCellInstances.getBoolean();
    }

    public static void setDaisReadCellInstances(boolean on) {
        cacheDaisReadCellInstances.setBoolean(on);
    }

    public static boolean isDaisReadDetailWires() {
        return cacheDaisReadDetailWires.getBoolean();
    }

    public static void setDaisReadDetailWires(boolean on) {
        cacheDaisReadDetailWires.setBoolean(on);
    }

    public static boolean isDaisReadGlobalWires() {
        return cacheDaisReadGlobalWires.getBoolean();
    }

    public static void setDaisReadGlobalWires(boolean on) {
        cacheDaisReadGlobalWires.setBoolean(on);
    }

    public static boolean isDaisReadPowerAndGround() {
        return cacheDaisReadPowerAndGround.getBoolean();
    }

    public static void setDaisReadPowerAndGround(boolean on) {
        cacheDaisReadPowerAndGround.setBoolean(on);
    }

    public static boolean isDaisReadConnectivity() {
        return cacheDaisReadConnectivity.getBoolean();
    }

    public static void setDaisReadConnectivity(boolean on) {
        cacheDaisReadConnectivity.setBoolean(on);
    }

    static {
        daisChecked = false;
        daisClass = null;
        cacheBackupRedundancy = Pref.makeIntPref("OutputBackupRedundancy", IOTool.tool.prefs, 0);
        cachePlotArea = Pref.makeIntPref("PlotArea", IOTool.tool.prefs, 0);
        cachePlotDate = Pref.makeBooleanPref("PlotDate", IOTool.tool.prefs, false);
        cachePrinterName = null;
        cacheCIFInSquaresWires = Pref.makeBooleanPref("CIFInSquaresWires", IOTool.tool.prefs, true);
        cacheDEFLogicalPlacement = Pref.makeBooleanPref("DEFLogicalPlacement", IOTool.tool.prefs, true);
        cacheDEFPhysicalPlacement = Pref.makeBooleanPref("DEFPhysicalPlacement", IOTool.tool.prefs, true);
        cacheGDSInMergesBoxes = Pref.makeBooleanPref("GDSInMergesBoxes", IOTool.tool.prefs, false);
        cacheGDSInIncludesText = Pref.makeBooleanPref("GDSInIncludesText", IOTool.tool.prefs, false);
        cacheGDSInExpandsCells = Pref.makeBooleanPref("GDSInExpandsCells", IOTool.tool.prefs, false);
        cacheGDSInInstantiatesArrays = Pref.makeBooleanPref("GDSInInstantiatesArrays", IOTool.tool.prefs, true);
        cacheGDSInIgnoresUnknownLayers = Pref.makeBooleanPref("GDSInIgnoresUnknownLayers", IOTool.tool.prefs, false);
        cacheGDSConvertNCCExportsConnectedByParentPins = Pref.makeBooleanPref("GDSConvertNCCEconnectedByParentPins", IOTool.tool.prefs, false);
        cacheGDSInSimplifyCells = Pref.makeBooleanPref("GDSInSimplifyCells", IOTool.tool.prefs, false);
        cacheGDSColapseVddGndPinNames = Pref.makeBooleanPref("cacheGDSColapseVddGndPinNames", IOTool.tool.prefs, false);
        cachePrintEncapsulated = Pref.makeBooleanPref("PostScriptEncapsulated", IOTool.tool.prefs, false);
        cachePrintResolution = Pref.makeIntPref("PrintResolution", IOTool.tool.prefs, 300);
        cachePrintForPlotter = Pref.makeBooleanPref("PostScriptForPlotter", IOTool.tool.prefs, false);
        cachePrintWidth = Pref.makeDoublePref("PostScriptWidth", IOTool.tool.prefs, 8.5);
        cachePrintHeight = Pref.makeDoublePref("PostScriptHeight", IOTool.tool.prefs, 11.0);
        cachePrintMargin = Pref.makeDoublePref("PostScriptMargin", IOTool.tool.prefs, 0.75);
        cachePrintRotation = Pref.makeIntPref("PostScriptRotation", IOTool.tool.prefs, 0);
        cachePrintColorMethod = Pref.makeIntPref("PostScriptColorMethod", IOTool.tool.prefs, 0);
        POSTSCRIPT_EPS_SCALE = Variable.newKey("IO_postscript_EPS_scale");
        POSTSCRIPT_FILENAME = Variable.newKey("IO_postscript_filename");
        POSTSCRIPT_FILEDATE = Variable.newKey("IO_postscript_filedate");
        cachePrintPSLineWidth = Pref.makeDoublePref("PostScriptLineWidth", IOTool.tool.prefs, 1.0);
        cacheEDIFUseSchematicView = Pref.makeBooleanPref("EDIFUseSchematicView", IOTool.tool.prefs, true);
        cacheEDIFCadenceCompatibility = Pref.makeBooleanPref("EDIFCadenceCompatibility", IOTool.tool.prefs, true);
        cacheEDIFInputScale = Pref.makeDoublePref("EDIFInputScale", IOTool.tool.prefs, 0.05);
        cacheEDIFConfigurationFile = Pref.makeStringPref("EDIFConfigurationFile", IOTool.tool.prefs, "");
        cacheDXFInputFlattensHierarchy = Pref.makeBooleanPref("DXFInputFlattensHierarchy", IOTool.tool.prefs, true);
        cacheDXFInputReadsAllLayers = Pref.makeBooleanPref("DXFInputReadsAllLayers", IOTool.tool.prefs, false);
        cacheSueUses4PortTransistors = Pref.makeBooleanPref("SueUses4PortTransistors", IOTool.tool.prefs, false);
        cacheSueConvertsExpressions = Pref.makeBooleanPref("SueConvertsExpressions", IOTool.tool.prefs, false);
        cacheSkillExcludesSubcells = Pref.makeBooleanPref("SkillExcludesSubcells", IOTool.tool.prefs, false);
        cacheSkillFlattensHierarchy = Pref.makeBooleanPref("SkillFlattensHierarchy", IOTool.tool.prefs, false);
        cacheSkillGDSNameLimit = Pref.makeBooleanPref("SkillGDSNameLimit", IOTool.tool.prefs, false);
        cacheDaisDisplayOnly = Pref.makeBooleanPref("DaisDisplayOnly", IOTool.tool.prefs, false);
        cacheDaisReadCellInstances = Pref.makeBooleanPref("DaisReadCellInstances", IOTool.tool.prefs, true);
        cacheDaisReadDetailWires = Pref.makeBooleanPref("DaisReadDetailWires", IOTool.tool.prefs, true);
        cacheDaisReadGlobalWires = Pref.makeBooleanPref("DaisReadGlobalWires", IOTool.tool.prefs, false);
        cacheDaisReadPowerAndGround = Pref.makeBooleanPref("DaisReadPowerAndGround", IOTool.tool.prefs, true);
        cacheDaisReadConnectivity = Pref.makeBooleanPref("DaisReadConnectivity", IOTool.tool.prefs, true);
    }
}

