/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.bytecode.ClassType;
import gnu.expr.ApplicationMainSupport;
import gnu.expr.Compilation;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.kawa.servlet.HttpRequestContext;
import gnu.kawa.servlet.KawaHttpHandler;
import gnu.lists.FString;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure0or1;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.text.WriterManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Vector;
import kawa.Shell;
import kawa.Telnet;
import kawa.TelnetInputStream;
import kawa.TelnetOutputStream;
import kawa.TelnetRepl;
import kawa.Version;

public class repl
extends Procedure0or1 {
    public static String compilationTopname = null;
    Language language;
    static Language previousLanguage;
    static int defaultParseOptions;
    public static String homeDirectory;
    static boolean shutdownRegistered;
    public static boolean noConsole;

    public repl(Language language) {
        this.language = language;
    }

    @Override
    public Object apply0() {
        Shell.run(this.language, Environment.getCurrent());
        return Values.empty;
    }

    @Override
    public Object apply1(Object env) {
        Shell.run(this.language, (Environment)env);
        return Values.empty;
    }

    static void bad_option(String str) {
        System.err.println("kawa: bad option '" + str + "'");
        repl.printOptions(System.err);
        System.exit(-1);
    }

    public static void printOption(PrintStream out, String option2, String doc) {
        out.print(" ");
        out.print(option2);
        int len = option2.length() + 1;
        for (int i = 0; i < 30 - len; ++i) {
            out.print(" ");
        }
        out.print(" ");
        out.println(doc);
    }

    public static void printOptions(PrintStream out) {
        out.println("Usage: [java kawa.repl | kawa] [options ...]");
        out.println();
        out.println(" Generic options:");
        repl.printOption(out, "--help", "Show help about options");
        repl.printOption(out, "--author", "Show author information");
        repl.printOption(out, "--version", "Show version information");
        out.println();
        out.println(" Options");
        repl.printOption(out, "-e <expr>", "Evaluate expression <expr>");
        repl.printOption(out, "-c <expr>", "Same as -e, but make sure ~/.kawarc.scm is run first");
        repl.printOption(out, "-f <filename>", "File to interpret");
        repl.printOption(out, "-s| --", "Start reading commands interactively from console");
        repl.printOption(out, "-w", "Launch the interpreter in a GUI window");
        repl.printOption(out, "--server <port>", "Start a server accepting telnet connections on <port>");
        repl.printOption(out, "--debug-dump-zip", "Compiled interactive expressions to a zip archive");
        repl.printOption(out, "--debug-print-expr", "Print generated internal expressions");
        repl.printOption(out, "--debug-print-final-expr", "Print expression after any optimizations");
        repl.printOption(out, "--debug-error-prints-stack-trace", "Print stack trace with errors");
        repl.printOption(out, "--debug-warning-prints-stack-trace", "Print stack trace with warnings");
        repl.printOption(out, "--[no-]full-tailcalls", "(Don't) use full tail-calls");
        repl.printOption(out, "-C <filename> ...", "Compile named files to Java class files");
        repl.printOption(out, "--output-format <format>", "Use <format> when printing top-level output");
        repl.printOption(out, "--<language>", "Select source language, one of:");
        String[][] languages = Language.getLanguages();
        for (int i = 0; i < languages.length; ++i) {
            out.print("   ");
            String[] lang = languages[i];
            int nwords = lang.length - 1;
            for (int j = 0; j < nwords; ++j) {
                out.print(lang[j] + " ");
            }
            if (i == 0) {
                out.print("[default]");
            }
            out.println();
        }
        out.println(" Compilation options, must be specified before -C");
        repl.printOption(out, "-d <dirname>", "Directory to place .class files in");
        repl.printOption(out, "-P <prefix>", "Prefix to prepand to class names");
        repl.printOption(out, "-T <topname>", "name to give to top-level class");
        repl.printOption(out, "--main", "Generate an application, with a main method");
        repl.printOption(out, "--applet", "Generate an applet");
        repl.printOption(out, "--servlet", "Generate a servlet");
        repl.printOption(out, "--module-static", "Top-level definitions are by default static");
        ArrayList<String> keys = Compilation.options.keys();
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i);
            repl.printOption(out, "--" + name, Compilation.options.getDoc(name));
        }
        out.println();
        out.println("For more information go to:  http://www.gnu.org/software/kawa/");
    }

    static void checkInitFile() {
        if (homeDirectory == null) {
            Comparable<Boolean> scmHomeDirectory;
            File initFile = null;
            homeDirectory = System.getProperty("user.home");
            if (homeDirectory != null) {
                scmHomeDirectory = new FString(homeDirectory);
                String file_separator = System.getProperty("file.separator");
                String kawarc_name = "/".equals(file_separator) ? ".kawarc.scm" : "kawarc.scm";
                initFile = new File(homeDirectory, kawarc_name);
            } else {
                scmHomeDirectory = Boolean.FALSE;
            }
            Environment.getCurrent().put("home-directory", (Object)scmHomeDirectory);
            if (initFile != null && initFile.exists() && !Shell.runFileOrClass(initFile.getPath(), true, 0)) {
                System.exit(-1);
            }
        }
    }

    public static void setArgs(String[] args, int arg_start) {
        ApplicationMainSupport.setArgs(args, arg_start);
    }

    public static void getLanguageFromFilenameExtension(String name) {
        if (previousLanguage == null && (previousLanguage = Language.getInstanceFromFilenameExtension(name)) != null) {
            Language.setDefaults(previousLanguage);
            return;
        }
        repl.getLanguage();
    }

    public static void getLanguage() {
        if (previousLanguage == null) {
            previousLanguage = Language.getInstance(null);
            Language.setDefaults(previousLanguage);
        }
    }

    public static int processArgs(String[] args, int iArg, int maxArg) {
        boolean something_done = false;
        while (iArg < maxArg) {
            String filename;
            String arg = args[iArg];
            if (arg.equals("-c") || arg.equals("-e")) {
                if (++iArg == maxArg) {
                    repl.bad_option(arg);
                }
                repl.getLanguage();
                repl.setArgs(args, iArg + 1);
                if (arg.equals("-c")) {
                    repl.checkInitFile();
                }
                Language language = Language.getDefaultLanguage();
                SourceMessages messages = new SourceMessages();
                Throwable ex = Shell.run(language, Environment.getCurrent(), (InPort)new CharArrayInPort(args[iArg]), OutPort.outDefault(), null, messages);
                if (ex != null) {
                    Shell.printError(ex, messages, OutPort.errDefault());
                    System.exit(-1);
                }
                something_done = true;
            } else if (arg.equals("-f")) {
                if (++iArg == maxArg) {
                    repl.bad_option(arg);
                }
                filename = args[iArg];
                repl.getLanguageFromFilenameExtension(filename);
                repl.setArgs(args, iArg + 1);
                repl.checkInitFile();
                if (!Shell.runFileOrClass(filename, true, 0)) {
                    System.exit(-1);
                }
                something_done = true;
            } else {
                if (arg.startsWith("--script")) {
                    String count = arg.substring(8);
                    ++iArg;
                    int skipLines = 0;
                    if (count.length() > 0) {
                        try {
                            skipLines = Integer.parseInt(count);
                        }
                        catch (Throwable ex) {
                            iArg = maxArg;
                        }
                    }
                    if (iArg == maxArg) {
                        repl.bad_option(arg);
                    }
                    String filename2 = args[iArg];
                    repl.getLanguageFromFilenameExtension(filename2);
                    repl.setArgs(args, iArg + 1);
                    repl.checkInitFile();
                    if (!Shell.runFileOrClass(filename2, true, skipLines)) {
                        System.exit(-1);
                    }
                    return -1;
                }
                if (arg.equals("\\")) {
                    if (++iArg == maxArg) {
                        repl.bad_option(arg);
                    }
                    filename = args[iArg];
                    SourceMessages messages = new SourceMessages();
                    try {
                        BufferedInputStream fstream = new BufferedInputStream(new FileInputStream(filename));
                        int ch = ((InputStream)fstream).read();
                        if (ch == 35) {
                            int nxargs;
                            StringBuffer sbuf = new StringBuffer(100);
                            Vector<String> xargs = new Vector<String>(10);
                            int state = 0;
                            while (ch != 10 && ch != 13 && ch >= 0) {
                                ch = ((InputStream)fstream).read();
                            }
                            while (true) {
                                if ((ch = ((InputStream)fstream).read()) < 0) {
                                    System.err.println("unexpected end-of-file processing argument line for: '" + filename + '\'');
                                    System.exit(-1);
                                }
                                if (state == 0) {
                                    if (ch == 92 || ch == 39 || ch == 34) {
                                        state = ch;
                                        continue;
                                    }
                                    if (ch == 10 || ch == 13) break;
                                    if (ch == 32 || ch == 9) {
                                        if (sbuf.length() <= 0) continue;
                                        xargs.addElement(sbuf.toString());
                                        sbuf.setLength(0);
                                        continue;
                                    }
                                } else if (state == 92) {
                                    state = 0;
                                } else if (ch == state) {
                                    state = 0;
                                    continue;
                                }
                                sbuf.append((char)ch);
                            }
                            if (sbuf.length() > 0) {
                                xargs.addElement(sbuf.toString());
                            }
                            if ((nxargs = xargs.size()) > 0) {
                                Object[] sargs = new String[nxargs];
                                xargs.copyInto(sargs);
                                int ixarg = repl.processArgs((String[])sargs, 0, nxargs);
                                if (ixarg >= 0 && ixarg < nxargs) {
                                    System.err.println("" + (nxargs - ixarg) + " unused meta args");
                                }
                            }
                        }
                        repl.getLanguageFromFilenameExtension(filename);
                        InPort freader = InPort.openFile(fstream, filename);
                        repl.setArgs(args, iArg + 1);
                        repl.checkInitFile();
                        OutPort err = OutPort.errDefault();
                        Throwable ex = Shell.run(Language.getDefaultLanguage(), Environment.getCurrent(), freader, OutPort.outDefault(), null, messages);
                        messages.printAll(err, 20);
                        if (ex != null) {
                            SyntaxException se;
                            if (ex instanceof SyntaxException && (se = (SyntaxException)ex).getMessages() == messages) {
                                System.exit(1);
                            }
                            throw ex;
                        }
                    }
                    catch (Throwable ex) {
                        Shell.printError(ex, messages, OutPort.errDefault());
                        System.exit(1);
                    }
                    return -1;
                }
                if (arg.equals("-s") || arg.equals("--")) {
                    repl.getLanguage();
                    repl.setArgs(args, ++iArg);
                    repl.checkInitFile();
                    Shell.run(Language.getDefaultLanguage(), Environment.getCurrent());
                    return -1;
                }
                if (arg.equals("-w")) {
                    repl.getLanguage();
                    repl.setArgs(args, ++iArg);
                    repl.checkInitFile();
                    repl.startGuiConsole();
                    something_done = true;
                } else if (arg.equals("-d")) {
                    if (++iArg == maxArg) {
                        repl.bad_option(arg);
                    }
                    ModuleManager manager = ModuleManager.getInstance();
                    manager.setCompilationDirectory(args[iArg]);
                } else if (arg.equals("--target") || arg.equals("target")) {
                    if (++iArg == maxArg) {
                        repl.bad_option(arg);
                    }
                    if ((arg = args[iArg]).equals("7")) {
                        Compilation.defaultClassFileVersion = 0x330000;
                    }
                    if (arg.equals("6") || arg.equals("1.6")) {
                        Compilation.defaultClassFileVersion = 0x320000;
                    } else if (arg.equals("5") || arg.equals("1.5")) {
                        Compilation.defaultClassFileVersion = 0x310000;
                    } else if (arg.equals("1.4")) {
                        Compilation.defaultClassFileVersion = 0x300000;
                    } else if (arg.equals("1.3")) {
                        Compilation.defaultClassFileVersion = 0x2F0000;
                    } else if (arg.equals("1.2")) {
                        Compilation.defaultClassFileVersion = 0x2E0000;
                    } else if (arg.equals("1.1")) {
                        Compilation.defaultClassFileVersion = 2949123;
                    } else {
                        repl.bad_option(arg);
                    }
                } else if (arg.equals("-P")) {
                    if (++iArg == maxArg) {
                        repl.bad_option(arg);
                    }
                    Compilation.classPrefixDefault = args[iArg];
                } else if (arg.equals("-T")) {
                    if (++iArg == maxArg) {
                        repl.bad_option(arg);
                    }
                    compilationTopname = args[iArg];
                } else {
                    if (arg.equals("-C")) {
                        if (++iArg == maxArg) {
                            repl.bad_option(arg);
                        }
                        repl.compileFiles(args, iArg, maxArg);
                        return -1;
                    }
                    if (arg.equals("--output-format") || arg.equals("--format")) {
                        if (++iArg == maxArg) {
                            repl.bad_option(arg);
                        }
                        Shell.setDefaultFormat(args[iArg]);
                    } else {
                        if (arg.equals("--connect")) {
                            int port;
                            if (++iArg == maxArg) {
                                repl.bad_option(arg);
                            }
                            if (args[iArg].equals("-")) {
                                port = 0;
                            } else {
                                try {
                                    port = Integer.parseInt(args[iArg]);
                                }
                                catch (NumberFormatException ex) {
                                    repl.bad_option("--connect port#");
                                    port = -1;
                                }
                            }
                            try {
                                Socket socket = new Socket(InetAddress.getByName(null), port);
                                Telnet conn = new Telnet(socket, true);
                                TelnetInputStream sin = conn.getInputStream();
                                TelnetOutputStream sout = conn.getOutputStream();
                                PrintStream pout = new PrintStream(sout, true);
                                System.setIn(sin);
                                System.setOut(pout);
                                System.setErr(pout);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace(System.err);
                                throw new Error(ex.toString());
                            }
                        }
                        if (arg.equals("--server")) {
                            int port;
                            repl.getLanguage();
                            if (++iArg == maxArg) {
                                repl.bad_option(arg);
                            }
                            if (args[iArg].equals("-")) {
                                port = 0;
                            } else {
                                try {
                                    port = Integer.parseInt(args[iArg]);
                                }
                                catch (NumberFormatException ex) {
                                    repl.bad_option("--server port#");
                                    port = -1;
                                }
                            }
                            try {
                                ServerSocket ssocket = new ServerSocket(port);
                                port = ssocket.getLocalPort();
                                System.err.println("Listening on port " + port);
                                while (true) {
                                    System.err.print("waiting ... ");
                                    System.err.flush();
                                    Socket client = ssocket.accept();
                                    System.err.println("got connection from " + client.getInetAddress() + " port:" + client.getPort());
                                    TelnetRepl.serve(Language.getDefaultLanguage(), client);
                                }
                            }
                            catch (IOException ex) {
                                throw new Error(ex.toString());
                            }
                        }
                        if (arg.equals("--http-auto-handler")) {
                            if ((iArg += 2) >= maxArg) {
                                repl.bad_option(arg);
                            }
                            try {
                                KawaHttpHandler.addAutoHandler(args[iArg - 1], args[iArg]);
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                            catch (NoClassDefFoundError ex) {
                                System.err.println("kawa: HttpServer classes not found");
                                System.exit(-1);
                            }
                        } else if (arg.equals("--http-start")) {
                            int port;
                            if (++iArg >= maxArg) {
                                repl.bad_option("missing httpd port argument");
                            }
                            try {
                                port = Integer.parseInt(args[iArg]);
                            }
                            catch (NumberFormatException ex) {
                                repl.bad_option("malformed server port#");
                                port = -1;
                            }
                            try {
                                KawaHttpHandler.startServer(port);
                            }
                            catch (NoClassDefFoundError ex) {
                                System.err.println("kawa: HttpServer classes not found");
                                System.exit(-1);
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                            something_done = true;
                        } else if (arg.equals("--main")) {
                            Compilation.generateMainDefault = true;
                        } else if (arg.equals("--applet")) {
                            defaultParseOptions |= 0x10;
                        } else if (arg.equals("--servlet")) {
                            defaultParseOptions |= 0x20;
                            HttpRequestContext.importServletDefinitions = 2;
                        } else if (arg.equals("--debug-dump-zip")) {
                            ModuleExp.dumpZipPrefix = "kawa-zip-dump-";
                        } else if (arg.equals("--debug-print-expr")) {
                            Compilation.debugPrintExpr = true;
                        } else if (arg.equals("--debug-print-final-expr")) {
                            Compilation.debugPrintFinalExpr = true;
                        } else if (arg.equals("--debug-error-prints-stack-trace")) {
                            SourceMessages.debugStackTraceOnError = true;
                        } else if (arg.equals("--debug-warning-prints-stack-trace")) {
                            SourceMessages.debugStackTraceOnWarning = true;
                        } else if (arg.equals("--module-nonstatic") || arg.equals("--no-module-static")) {
                            Compilation.moduleStatic = -1;
                        } else if (arg.equals("--module-static")) {
                            Compilation.moduleStatic = 1;
                        } else if (arg.equals("--module-static-run")) {
                            Compilation.moduleStatic = 2;
                        } else if (arg.equals("--no-inline") || arg.equals("--inline=none")) {
                            Compilation.inlineOk = false;
                        } else if (arg.equals("--no-console")) {
                            noConsole = true;
                        } else if (arg.equals("--inline")) {
                            Compilation.inlineOk = true;
                        } else if (arg.equals("--cps")) {
                            Compilation.defaultCallConvention = 4;
                        } else if (arg.equals("--full-tailcalls")) {
                            Compilation.defaultCallConvention = 3;
                        } else if (arg.equals("--no-full-tailcalls")) {
                            Compilation.defaultCallConvention = 1;
                        } else if (arg.equals("--pedantic")) {
                            Language.requirePedantic = true;
                        } else if (arg.equals("--help")) {
                            repl.printOptions(System.out);
                            System.exit(0);
                        } else if (arg.equals("--author")) {
                            System.out.println("Per Bothner <per@bothner.com>");
                            System.exit(0);
                        } else if (arg.equals("--version")) {
                            System.out.print("Kawa ");
                            System.out.print(Version.getVersion());
                            System.out.println();
                            System.out.println("Copyright (C) 2009 Per Bothner");
                            something_done = true;
                        } else if (arg.length() > 0 && arg.charAt(0) == '-') {
                            Language lang;
                            String name = arg;
                            if (name.length() > 2 && name.charAt(0) == '-') {
                                name = name.substring(name.charAt(1) == '-' ? 2 : 1);
                            }
                            if ((lang = Language.getInstance(name)) != null) {
                                if (previousLanguage == null) {
                                    Language.setDefaults(lang);
                                } else {
                                    Language.setCurrentLanguage(lang);
                                }
                                previousLanguage = lang;
                            } else {
                                String msg;
                                boolean startsWithNo;
                                String opt_value;
                                int eq = name.indexOf("=");
                                if (eq < 0) {
                                    opt_value = null;
                                } else {
                                    opt_value = name.substring(eq + 1);
                                    name = name.substring(0, eq);
                                }
                                boolean bl = startsWithNo = name.startsWith("no-") && name.length() > 3;
                                if (opt_value == null && startsWithNo) {
                                    opt_value = "no";
                                    name = name.substring(3);
                                }
                                if ((msg = Compilation.options.set(name, opt_value)) != null) {
                                    if (startsWithNo && msg == "unknown option name") {
                                        msg = "both '--no-' prefix and '=" + opt_value + "' specified";
                                    }
                                    if (msg == "unknown option name") {
                                        repl.bad_option(arg);
                                    } else {
                                        System.err.println("kawa: bad option '" + arg + "': " + msg);
                                        System.exit(-1);
                                    }
                                }
                            }
                        } else if (!ApplicationMainSupport.processSetProperty(arg)) break;
                    }
                }
            }
            ++iArg;
        }
        return something_done ? -1 : iArg;
    }

    public static void compileFiles(String[] args, int iArg, int maxArg) {
        String arg;
        int i;
        ModuleManager manager = ModuleManager.getInstance();
        Compilation[] comps = new Compilation[maxArg - iArg];
        ModuleInfo[] infos = new ModuleInfo[maxArg - iArg];
        SourceMessages messages = new SourceMessages();
        for (i = iArg; i < maxArg; ++i) {
            block10: {
                arg = args[i];
                repl.getLanguageFromFilenameExtension(arg);
                Language language = Language.getDefaultLanguage();
                Compilation comp = null;
                try {
                    InPort fstream;
                    try {
                        fstream = InPort.openFile(arg);
                    }
                    catch (FileNotFoundException ex) {
                        System.err.println(ex);
                        System.exit(-1);
                        break;
                    }
                    comp = language.parse(fstream, messages, defaultParseOptions);
                    if (compilationTopname != null) {
                        String cname = Compilation.mangleNameIfNeeded(compilationTopname);
                        ClassType ctype = new ClassType(cname);
                        ModuleExp mexp = comp.getModule();
                        mexp.setType(ctype);
                        mexp.setName(compilationTopname);
                        comp.mainClass = ctype;
                    }
                    infos[i - iArg] = manager.find(comp);
                    comps[i - iArg] = comp;
                }
                catch (Throwable ex) {
                    if (ex instanceof SyntaxException && ((SyntaxException)ex).getMessages() == messages) break block10;
                    repl.internalError(ex, comp, arg);
                }
            }
            if (!messages.seenErrorsOrWarnings()) continue;
            System.err.println("(compiling " + arg + ')');
            if (!messages.checkErrors(System.err, 20)) continue;
            System.exit(1);
        }
        for (i = iArg; i < maxArg; ++i) {
            arg = args[i];
            Compilation comp = comps[i - iArg];
            try {
                System.err.println("(compiling " + arg + " to " + comp.mainClass.getName() + ')');
                infos[i - iArg].loadByStages(14);
                boolean sawErrors = messages.seenErrors();
                messages.checkErrors(System.err, 50);
                if (sawErrors) {
                    System.exit(-1);
                }
                comps[i - iArg] = comp;
                sawErrors = messages.seenErrors();
                messages.checkErrors(System.err, 50);
                if (!sawErrors) continue;
                System.exit(-1);
                continue;
            }
            catch (Throwable ex) {
                repl.internalError(ex, comp, arg);
            }
        }
    }

    static void internalError(Throwable ex, Compilation comp, Object arg) {
        StringBuffer sbuf = new StringBuffer();
        if (comp != null) {
            String file = comp.getFileName();
            int line = comp.getLineNumber();
            if (file != null && line > 0) {
                sbuf.append(file);
                sbuf.append(':');
                sbuf.append(line);
                sbuf.append(": ");
            }
        }
        sbuf.append("internal error while compiling ");
        sbuf.append(arg);
        System.err.println(sbuf.toString());
        ex.printStackTrace(System.err);
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            int iArg = repl.processArgs(args, 0, args.length);
            if (iArg < 0) {
                return;
            }
            if (iArg < args.length) {
                String filename = args[iArg];
                repl.getLanguageFromFilenameExtension(filename);
                repl.setArgs(args, iArg + 1);
                repl.checkInitFile();
                boolean ok = Shell.runFileOrClass(filename, false, 0);
            } else {
                repl.getLanguage();
                repl.setArgs(args, iArg);
                repl.checkInitFile();
                if (repl.shouldUseGuiConsole()) {
                    repl.startGuiConsole();
                } else {
                    boolean ok = Shell.run(Language.getDefaultLanguage(), Environment.getCurrent());
                    if (!ok) {
                        System.exit(-1);
                    }
                }
            }
        }
        finally {
            if (!shutdownRegistered) {
                OutPort.runCleanups();
            }
            ModuleBody.exitDecrement();
        }
    }

    public static boolean shouldUseGuiConsole() {
        if (noConsole) {
            return true;
        }
        try {
            if (Class.forName("java.lang.System").getMethod("console", new Class[0]).invoke((Object)new Object[0], new Object[0]) == null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void startGuiConsole() {
        try {
            Class.forName("kawa.GuiConsole").newInstance();
        }
        catch (Exception ex) {
            System.err.println("failed to create Kawa window: " + ex);
            System.exit(-1);
        }
    }

    static {
        defaultParseOptions = 72;
        shutdownRegistered = WriterManager.instance.registerShutdownHook();
    }
}

