/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jheora.Comment;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.State;
import com.fluendo.jheora.YUVBuffer;
import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.plugin.OggPayload;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import java.util.Vector;

public class TheoraDec
extends Element
implements OggPayload {
    private static final byte[] signature = new byte[]{-128, 116, 104, 101, 111, 114, 97};
    private Info ti;
    private Comment tc;
    private State ts;
    private Packet op;
    private int packet;
    private YUVBuffer yuv;
    private long lastTs;
    private boolean needKeyframe;
    private boolean haveDecoder = false;
    private Pad srcPad = new Pad(1, "src"){

        protected boolean eventFunc(Event event) {
            return TheoraDec.this.sinkPad.pushEvent(event);
        }
    };
    private Pad sinkPad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            boolean bl;
            switch (event.getType()) {
                case 1: {
                    bl = TheoraDec.this.srcPad.pushEvent(event);
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, "synced " + this);
                        break;
                    }
                }
                case 2: {
                    bl = TheoraDec.this.srcPad.pushEvent(event);
                    break;
                }
                case 3: {
                    Debug.log(3, "got EOS " + this);
                    bl = TheoraDec.this.srcPad.pushEvent(event);
                    break;
                }
                default: {
                    bl = TheoraDec.this.srcPad.pushEvent(event);
                }
            }
            return bl;
        }

        protected int chainFunc(Buffer buffer) {
            int n;
            Debug.log(4, this.parent.getName() + " <<< " + buffer);
            ((TheoraDec)TheoraDec.this).op.packet_base = buffer.data;
            ((TheoraDec)TheoraDec.this).op.packet = buffer.offset;
            ((TheoraDec)TheoraDec.this).op.bytes = buffer.length;
            ((TheoraDec)TheoraDec.this).op.b_o_s = TheoraDec.this.packet == 0 ? 1 : 0;
            ((TheoraDec)TheoraDec.this).op.e_o_s = 0;
            ((TheoraDec)TheoraDec.this).op.packetno = TheoraDec.this.packet;
            long l = buffer.timestamp;
            if (buffer.isFlagSet(1)) {
                Debug.log(3, "theora: got discont");
                TheoraDec.this.needKeyframe = true;
                TheoraDec.this.lastTs = -1L;
            }
            if (TheoraDec.this.packet < 3) {
                if (TheoraDec.this.takeHeader(TheoraDec.this.op) < 0) {
                    buffer.free();
                    Debug.log(1, "does not contain Theora video data.");
                    return -5;
                }
                if (TheoraDec.this.packet == 2) {
                    TheoraDec.this.ts.decodeInit(TheoraDec.this.ti);
                    Debug.log(3, "theora dimension: " + ((TheoraDec)TheoraDec.this).ti.width + "x" + ((TheoraDec)TheoraDec.this).ti.height);
                    if (((TheoraDec)TheoraDec.this).ti.aspect_denominator == 0) {
                        ((TheoraDec)TheoraDec.this).ti.aspect_numerator = 1;
                        ((TheoraDec)TheoraDec.this).ti.aspect_denominator = 1;
                    }
                    Debug.log(3, "theora offset: " + ((TheoraDec)TheoraDec.this).ti.offset_x + "," + ((TheoraDec)TheoraDec.this).ti.offset_y);
                    Debug.log(3, "theora frame: " + ((TheoraDec)TheoraDec.this).ti.frame_width + "," + ((TheoraDec)TheoraDec.this).ti.frame_height);
                    Debug.log(3, "theora aspect: " + ((TheoraDec)TheoraDec.this).ti.aspect_numerator + "/" + ((TheoraDec)TheoraDec.this).ti.aspect_denominator);
                    Debug.log(3, "theora framerate: " + ((TheoraDec)TheoraDec.this).ti.fps_numerator + "/" + ((TheoraDec)TheoraDec.this).ti.fps_denominator);
                    this.caps = new Caps("video/raw");
                    this.caps.setFieldInt("width", ((TheoraDec)TheoraDec.this).ti.frame_width);
                    this.caps.setFieldInt("height", ((TheoraDec)TheoraDec.this).ti.frame_height);
                    this.caps.setFieldInt("aspect_x", ((TheoraDec)TheoraDec.this).ti.aspect_numerator);
                    this.caps.setFieldInt("aspect_y", ((TheoraDec)TheoraDec.this).ti.aspect_denominator);
                }
                buffer.free();
                TheoraDec.this.packet++;
                return 0;
            }
            if ((((TheoraDec)TheoraDec.this).op.packet_base[((TheoraDec)TheoraDec.this).op.packet] & 0x80) == 128) {
                Debug.log(3, "ignoring header");
                return 0;
            }
            if (TheoraDec.this.needKeyframe && TheoraDec.this.ts.isKeyframe(TheoraDec.this.op)) {
                TheoraDec.this.needKeyframe = false;
            }
            if (l != -1L) {
                TheoraDec.this.lastTs = l;
            } else if (TheoraDec.this.lastTs != -1L) {
                long l2 = 1000000L * (long)((TheoraDec)TheoraDec.this).ti.fps_denominator / (long)((TheoraDec)TheoraDec.this).ti.fps_numerator;
                TheoraDec.this.lastTs += l2;
                l = TheoraDec.this.lastTs;
            }
            if (!TheoraDec.this.needKeyframe) {
                try {
                    if (TheoraDec.this.ts.decodePacketin(TheoraDec.this.op) != 0) {
                        buffer.free();
                        Debug.log(1, "Error Decoding Theora.");
                        TheoraDec.this.postMessage(Message.newError(this, "Error decoding Theora"));
                        return -5;
                    }
                    if (TheoraDec.this.ts.decodeYUVout(TheoraDec.this.yuv) != 0) {
                        buffer.free();
                        TheoraDec.this.postMessage(Message.newError(this, "Error getting the Theora picture"));
                        Debug.log(1, "Error getting the picture.");
                        return -5;
                    }
                    buffer.object = TheoraDec.this.yuv.getObject(((TheoraDec)TheoraDec.this).ti.offset_x, ((TheoraDec)TheoraDec.this).ti.offset_y, ((TheoraDec)TheoraDec.this).ti.frame_width, ((TheoraDec)TheoraDec.this).ti.frame_height);
                    buffer.caps = this.caps;
                    buffer.timestamp = l;
                    Debug.log(4, this.parent.getName() + " >>> " + buffer);
                    n = TheoraDec.this.srcPad.push(buffer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    TheoraDec.this.postMessage(Message.newError(this, exception.getMessage()));
                    n = -5;
                }
            } else {
                n = 0;
                buffer.free();
            }
            TheoraDec.this.packet++;
            return n;
        }

        protected boolean activateFunc(int n) {
            return true;
        }
    };

    public boolean isType(Packet packet) {
        return this.typeFind(packet.packet_base, packet.packet, packet.bytes) > 0;
    }

    public int takeHeader(Packet packet) {
        int n = this.ti.decodeHeader(this.tc, packet);
        byte by = packet.packet_base[packet.packet];
        if (by == -126) {
            this.ts.decodeInit(this.ti);
            this.haveDecoder = true;
        }
        return n;
    }

    public boolean isHeader(Packet packet) {
        return (packet.packet_base[packet.packet] & 0x80) == 128;
    }

    public boolean isKeyFrame(Packet packet) {
        return this.ts.isKeyframe(packet);
    }

    public long getFirstTs(Vector vector) {
        int n;
        int n2 = vector.size();
        Buffer buffer = null;
        for (n = 0; n < n2; ++n) {
            buffer = (Buffer)vector.elementAt(n);
            if (buffer.time_offset != -1L) break;
        }
        if (n == vector.size()) {
            return -1L;
        }
        long l = this.granuleToTime(buffer.time_offset);
        buffer = (Buffer)vector.elementAt(0);
        buffer.timestamp = l - (long)(n + 1) * (1000000L * (long)this.ti.fps_denominator / (long)this.ti.fps_numerator);
        return l;
    }

    public long granuleToTime(long l) {
        if (l < 0L || !this.haveDecoder) {
            return -1L;
        }
        long l2 = (long)(this.ts.granuleTime(l) * 1000000.0);
        return l2;
    }

    public TheoraDec() {
        this.ti = new Info();
        this.tc = new Comment();
        this.ts = new State();
        this.yuv = new YUVBuffer();
        this.op = new Packet();
        this.addPad(this.srcPad);
        this.addPad(this.sinkPad);
    }

    protected int changeState(int n) {
        switch (n) {
            case 18: {
                this.lastTs = -1L;
                this.packet = 0;
                this.needKeyframe = true;
                break;
            }
        }
        int n2 = super.changeState(n);
        switch (n) {
            case 33: {
                this.ti.clear();
                this.tc.clear();
                this.ts.clear();
                break;
            }
        }
        return n2;
    }

    public String getFactoryName() {
        return "theoradec";
    }

    public String getMime() {
        return "video/x-theora";
    }

    public int typeFind(byte[] byArray, int n, int n2) {
        if (MemUtils.startsWith(byArray, n, n2, signature)) {
            return 10;
        }
        return -1;
    }
}

